/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.citizen;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.citizen.AbstractWindowCitizen;
import com.minecolonies.coremod.network.messages.server.colony.UpdateRequestStateMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.TransferItemsToCitizenRequestMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class RequestWindowCitizen
extends AbstractWindowCitizen {
    private final ICitizenDataView citizen;
    private final PlayerInventory inventory;
    private final boolean isCreative;

    public RequestWindowCitizen(ICitizenDataView citizen) {
        super(citizen, "minecolonies:gui/citizen/requests.xml");
        this.inventory = this.mc.field_71439_g.field_71071_by;
        this.isCreative = this.mc.field_71439_g.func_184812_l_();
        this.citizen = citizen;
    }

    public ICitizenDataView getCitizen() {
        return this.citizen;
    }

    @Override
    public boolean canFulFill() {
        return true;
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequestsFromBuilding(IBuildingView building) {
        IRequest<?> request;
        if (building == null) {
            return ImmutableList.of();
        }
        ArrayList requests = new ArrayList();
        for (IToken req : (Collection)building.getOpenRequestsByCitizen().getOrDefault(this.citizen.getId(), Collections.emptyList())) {
            if (req == null || (request = this.colony.getRequestManager().getRequestForToken(req)) == null) continue;
            requests.add(request);
        }
        for (IToken req : (Collection)building.getOpenRequestsByCitizen().getOrDefault(-1, Collections.emptyList())) {
            if (req == null || (request = this.colony.getRequestManager().getRequestForToken(req)) == null) continue;
            requests.add(request);
        }
        return ImmutableList.copyOf(requests);
    }

    @Override
    public void fulfill(@NotNull IRequest<?> tRequest) {
        ItemStack itemStack;
        if (!(tRequest.getRequest() instanceof IDeliverable)) {
            return;
        }
        @NotNull IRequest<?> request = tRequest;
        Predicate<ItemStack> requestPredicate = stack -> ((IDeliverable)request.getRequest()).matches((ItemStack)stack);
        int amount = ((IDeliverable)request.getRequest()).getCount();
        int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate);
        if (!this.isCreative && count <= 0) {
            return;
        }
        if (this.isCreative) {
            itemStack = request.getDisplayStacks().stream().findFirst().orElse(ItemStack.field_190927_a);
        } else {
            List<Integer> slots = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate);
            int invSize = this.inventory.func_70302_i_() - 5;
            int slot = -1;
            for (Integer possibleSlot : slots) {
                if (possibleSlot >= invSize) continue;
                slot = possibleSlot;
                break;
            }
            if (slot == -1) {
                MessageUtils.format("<%s> ", new Object[0]).with(TextFormatting.BOLD, TextFormatting.WHITE).append("com.minecolonies.coremod.general.canttakeequipped", this.citizen.getName()).sendTo(new PlayerEntity[]{Minecraft.func_71410_x().field_71439_g});
                return;
            }
            itemStack = this.inventory.func_70301_a(slot);
        }
        if (this.citizen.getWorkBuilding() != null) {
            this.colony.getBuilding(this.citizen.getWorkBuilding()).onRequestedRequestComplete(this.colony.getRequestManager(), tRequest);
        }
        Network.getNetwork().sendToServer(new TransferItemsToCitizenRequestMessage(this.colony, this.citizen, itemStack, this.isCreative ? amount : Math.min(amount, count)));
        ItemStack copy = itemStack.func_77946_l();
        copy.func_190920_e(this.isCreative ? amount : Math.min(amount, count));
        Network.getNetwork().sendToServer(new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.OVERRULED, copy));
    }
}

